import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.AssertionStatusItem;
import org.uddi4j.response.AssertionStatusReport;
import org.uddi4j.response.AuthToken;
import org.uddi4j.transport.TransportFactory;
import java.security.Security;
import java.util.Vector;

public class UDDIGetAssertionStatusReport1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		AuthToken at = proxy.get_authToken("user", "password");

		AssertionStatusReport asr = proxy.get_assertionStatusReport(at.getAuthInfoString(), "");

		Vector asis = asr.getAssertionStatusItemVector();
		if (asis.size() == 0) {
			System.out.println("no assertion(s) found");
		}
		else {
			System.out.println(asis.size()+" assertion(s) found\n");
			for (int i = 0; i < asis.size(); i++) {
				AssertionStatusItem asi = (AssertionStatusItem)asis.elementAt(i);
				System.out.println("fromKey : "+asi.getFromKeyString());
				System.out.println("toKey   : "+asi.getToKeyString());
				System.out.println("name    : "+asi.getKeyedReference().getKeyName());
				System.out.println("value   : "+asi.getKeyedReference().getKeyValue());
				System.out.println(asi.getCompletionStatus().getText());
				System.out.println("\n");
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}